/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.jorigin.Common;
import org.jorigin.lang.PathUtil;
import org.jorigin.plugin.IPlugin;
import org.jorigin.plugin.PluginToolkitEvent;
import org.jorigin.plugin.PluginToolkitListener;

public class PluginToolkit {
    private ArrayList<IPlugin> plugins = null;
    private ArrayList<File> pluginDirs = null;
    private String corePackage = null;
    private int taskCurrentTime = 0;
    protected EventListenerList idListenerList = new EventListenerList();

    public PluginToolkit() {
        this.pluginDirs = new ArrayList();
    }

    public boolean addPluginDir(String pluginDir) {
        File f;
        if (pluginDir != null && !this.pluginDirs.contains(f = new File(PathUtil.URIToPath(pluginDir)))) {
            return this.pluginDirs.add(f);
        }
        return false;
    }

    public boolean addPluginDir(File pluginDir) {
        if (pluginDir != null && !this.pluginDirs.contains(pluginDir)) {
            return this.pluginDirs.add(pluginDir);
        }
        return false;
    }

    public boolean removePluginDir(String pluginDir) {
        if (pluginDir != null) {
            File f = new File(PathUtil.URIToPath(pluginDir));
            return this.removePluginDir(f);
        }
        return false;
    }

    public boolean removePluginDir(File pluginDir) {
        return this.pluginDirs.remove(pluginDir);
    }

    public void setPluginPackage(String pluginPackage) {
        this.corePackage = pluginPackage;
    }

    public void addPluginToolkitListener(PluginToolkitListener l) {
        this.idListenerList.add(PluginToolkitListener.class, l);
    }

    public void removePluginToolkitListener(PluginToolkitListener l) {
        this.idListenerList.remove(PluginToolkitListener.class, l);
    }

    protected void fireEvent(PluginToolkitEvent e) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PluginToolkitListener.class) continue;
            ((PluginToolkitListener)listeners[i + 1]).eventDispatched(e);
        }
    }

    public ArrayList<IPlugin> loadPlugins() {
        IPlugin ap = null;
        this.plugins = new ArrayList();
        Object pluginClass = null;
        Iterator<File> fileIter = null;
        File pluginDir2 = null;
        ArrayList<Object> pluginClassNames = null;
        String[] corePluginFiles = null;
        String archive = null;
        String path = null;
        File jarFile = null;
        JarInputStream jis = null;
        JarEntry jarEntry = null;
        this.fireEvent(new PluginToolkitEvent((Object)this, 2000, "Plugin discovering", (double)this.pluginDirs.size()));
        for (File pluginDir2 : this.pluginDirs) {
            if (pluginDir2.getPath().contains("!")) {
                archive = pluginDir2.getPath().split("!")[0];
                path = pluginDir2.getPath().split("!")[1];
                archive = PathUtil.URIToPath(archive);
                if ((path = path.replace("\\", "/")).startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (archive != null) {
                if (!archive.endsWith(".jar")) continue;
                Common.logger.log(Level.INFO, "[PluginToolKit][loadPlugins()] Plugin load from jar file: " + archive);
                Common.logger.log(Level.INFO, "[PluginToolKit][loadPlugins()]  - directory             : " + path);
                this.fireEvent(new PluginToolkitEvent(this, 2002, archive));
                try {
                    switch (PathUtil.getProtocol(archive)) {
                        case 1: 
                        case 2: {
                            jarFile = new File(PathUtil.URIToPath(archive));
                            jis = new JarInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
                            break;
                        }
                        case 3: {
                            jis = new JarInputStream(new BufferedInputStream(PathUtil.pathToURL(archive).openStream()));
                            break;
                        }
                    }
                    if (jis != null) {
                        if (pluginClassNames == null) {
                            pluginClassNames = new ArrayList();
                        }
                        jarEntry = jis.getNextJarEntry();
                        while (jarEntry != null) {
                            if (jarEntry.getName().startsWith(path) && jarEntry.getName().toUpperCase().endsWith("PLUGIN.CLASS")) {
                                pluginClass = jarEntry.getName().substring(0, jarEntry.getName().lastIndexOf("."));
                                pluginClass = ((String)pluginClass).replace("/", ".");
                                pluginClassNames.add(pluginClass);
                                Common.logger.log(Level.INFO, "[PluginToolKit][loadPlugins()]  - Found plugin: " + (String)pluginClass);
                            }
                            jarEntry = jis.getNextJarEntry();
                        }
                        if (pluginClassNames.size() >= 1) continue;
                        Common.logger.log(Level.INFO, "[PluginToolKit][loadPlugins()]  - No plugin available");
                        this.fireEvent(new PluginToolkitEvent(this, 2004, archive));
                        continue;
                    }
                    Common.logger.log(Level.SEVERE, "[PluginToolKit][loadPlugins()] Unable to open stream from archive " + archive);
                }
                catch (IOException ex) {
                    Common.logger.log(Level.SEVERE, "[PluginToolKit][loadPlugins()] Cannot open jar " + archive, ex);
                }
                continue;
            }
            Common.logger.log(Level.INFO, "[PluginToolKit][initPlugins()] Plugin load from dir : " + pluginDir2.getPath());
            this.fireEvent(new PluginToolkitEvent(this, 2003, pluginDir2.getPath()));
            try {
                corePluginFiles = pluginDir2.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (name.endsWith("Plugin.class")) {
                            return !name.equals("IPlugin.class");
                        }
                        return false;
                    }
                });
                if (corePluginFiles != null) {
                    if (pluginClassNames == null) {
                        pluginClassNames = new ArrayList<Object>();
                    }
                    for (int i = 0; i < corePluginFiles.length; ++i) {
                        pluginClass = corePluginFiles[i].replace(File.separatorChar, '.');
                        pluginClass = ((String)pluginClass).substring(0, ((String)pluginClass).length() - 6);
                        if ((pluginClass = this.corePackage + "." + (String)pluginClass) != null) {
                            pluginClassNames.add(pluginClass);
                        }
                        Common.logger.log(Level.INFO, "[PluginToolKit][loadPlugins()]  - Found plugin: " + (String)pluginClass);
                    }
                    continue;
                }
                Common.logger.log(Level.SEVERE, "[PluginToolKit][loadPlugins()] Unable to list plugin dir: " + pluginDir2.getPath());
            }
            catch (Exception ex) {
                Common.logger.log(Level.SEVERE, "[PluginToolKit][loadPlugins()] Unable to list plugin dir: " + pluginDir2.getPath(), ex);
            }
        }
        this.fireEvent(new PluginToolkitEvent(this, 2001, "Plugin discovering finished"));
        if (pluginClassNames != null && pluginClassNames.size() > 0) {
            this.fireEvent(new PluginToolkitEvent((Object)this, 2005, "", (double)pluginClassNames.size()));
            for (int i = 0; i < pluginClassNames.size(); ++i) {
                try {
                    pluginClass = (String)pluginClassNames.get(i);
                    Common.logger.log(Level.INFO, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass);
                    ap = (IPlugin)Class.forName((String)pluginClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.plugins.add(ap);
                    ++this.taskCurrentTime;
                    this.fireEvent(new PluginToolkitEvent((Object)this, 2007, ap, (double)this.taskCurrentTime));
                    Common.logger.log(Level.INFO, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass + " [OK]");
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    Common.logger.log(Level.SEVERE, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass + " [FAIL]");
                    Common.logger.log(Level.SEVERE, "PluginToolkit Cannot register plugin " + (String)pluginClass);
                    Common.logger.log(Level.SEVERE, "the plugin is not available", ex);
                    ++this.taskCurrentTime;
                    this.fireEvent(new PluginToolkitEvent((Object)this, 2008, pluginDir2.getPath(), (double)this.taskCurrentTime));
                    continue;
                }
                catch (IllegalAccessException ex) {
                    Common.logger.log(Level.SEVERE, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass + " [FAIL]");
                    Common.logger.log(Level.SEVERE, "Cannot register plugin " + (String)pluginClass);
                    Common.logger.log(Level.SEVERE, "the plugin cannot be accessed (illegal access)", ex);
                    ++this.taskCurrentTime;
                    this.fireEvent(new PluginToolkitEvent((Object)this, 2008, pluginDir2.getPath(), (double)this.taskCurrentTime));
                    continue;
                }
                catch (InstantiationException ex) {
                    Common.logger.log(Level.SEVERE, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass + " [FAIL]");
                    Common.logger.log(Level.SEVERE, "Cannot register plugin " + (String)pluginClass);
                    Common.logger.log(Level.SEVERE, "the plugin cannot be instanciated", ex);
                    ++this.taskCurrentTime;
                    this.fireEvent(new PluginToolkitEvent((Object)this, 2008, pluginDir2.getPath(), (double)this.taskCurrentTime));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Common.logger.log(Level.SEVERE, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass + " [FAIL]");
                    Common.logger.log(Level.SEVERE, "Cannot register plugin " + (String)pluginClass);
                    Common.logger.log(Level.SEVERE, "the plugin cannot be instanciated", ex);
                    ++this.taskCurrentTime;
                    this.fireEvent(new PluginToolkitEvent((Object)this, 2008, pluginDir2.getPath(), (double)this.taskCurrentTime));
                    continue;
                }
                catch (InvocationTargetException ex) {
                    Common.logger.log(Level.SEVERE, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass + " [FAIL]");
                    Common.logger.log(Level.SEVERE, "Cannot register plugin " + (String)pluginClass);
                    Common.logger.log(Level.SEVERE, "the plugin cannot be instanciated", ex);
                    ++this.taskCurrentTime;
                    this.fireEvent(new PluginToolkitEvent((Object)this, 2008, pluginDir2.getPath(), (double)this.taskCurrentTime));
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    Common.logger.log(Level.SEVERE, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass + " [FAIL]");
                    Common.logger.log(Level.SEVERE, "Cannot register plugin " + (String)pluginClass);
                    Common.logger.log(Level.SEVERE, "the plugin cannot be instanciated", ex);
                    ++this.taskCurrentTime;
                    this.fireEvent(new PluginToolkitEvent((Object)this, 2008, pluginDir2.getPath(), (double)this.taskCurrentTime));
                    continue;
                }
                catch (SecurityException ex) {
                    Common.logger.log(Level.SEVERE, "[PluginToolkit][loadPlugins()]  - Load " + (String)pluginClass + " [FAIL]");
                    Common.logger.log(Level.SEVERE, "Cannot register plugin " + (String)pluginClass);
                    Common.logger.log(Level.SEVERE, "the plugin cannot be instanciated", ex);
                    ++this.taskCurrentTime;
                    this.fireEvent(new PluginToolkitEvent((Object)this, 2008, pluginDir2.getPath(), (double)this.taskCurrentTime));
                }
            }
        } else {
            this.plugins = null;
        }
        return this.plugins;
    }
}

