/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.logging;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class LogHandler
extends StreamHandler {
    private void configure() {
        Filter filter = new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return true;
            }
        };
        Formatter formatter = new Formatter(){
            private String lineSeparator = System.getProperty("line.separator");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss");

            @Override
            public String format(LogRecord record) {
                if (record.getThrown() == null) {
                    return "(" + this.sdf.format(new Date(record.getMillis())) + ") " + String.valueOf(record.getLevel()) + " [" + record.getSourceClassName() + "] [" + record.getSourceMethodName() + "] " + record.getMessage() + this.lineSeparator;
                }
                String str = "(" + this.sdf.format(new Date(record.getMillis())) + ") " + String.valueOf(record.getLevel()) + " [" + record.getSourceClassName() + "] [" + record.getSourceMethodName() + "] caused by " + record.getThrown().getMessage() + this.lineSeparator;
                StackTraceElement[] elements = record.getThrown().getStackTrace();
                for (int i = 0; i < elements.length; ++i) {
                    str = str + "(" + this.sdf.format(new Date(record.getMillis())) + ") " + String.valueOf(record.getLevel()) + " [" + record.getSourceClassName() + "] [" + record.getSourceMethodName() + "] at " + String.valueOf(elements[i]) + this.lineSeparator;
                }
                return "(" + this.sdf.format(new Date(record.getMillis())) + ") " + String.valueOf(record.getLevel()) + " [" + record.getSourceClassName() + "] [" + record.getSourceMethodName() + "] " + record.getMessage() + this.lineSeparator + str;
            }
        };
        this.setFilter(filter);
        this.setFormatter(formatter);
        try {
            this.setEncoding("UTF-8");
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LogHandler() {
        this.configure();
        this.setOutputStream(System.out);
        this.setLevel(Level.CONFIG);
    }

    public LogHandler(OutputStream output) {
        this.configure();
        this.setOutputStream(output);
        this.setLevel(Level.CONFIG);
    }

    public LogHandler(OutputStream output, Level level) {
        this.configure();
        this.setOutputStream(output);
        this.setLevel(level);
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    @Override
    public void close() {
        this.flush();
    }
}

