/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jorigin.lang.PathUtil;

public class FileUtil {
    public static long size(File path) {
        long result = 0L;
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files == null) {
                return path.length();
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    result += FileUtil.size(files[i]);
                    continue;
                }
                result += files[i].length();
            }
        }
        return result;
    }

    public static boolean deleteDirectory(File path) {
        boolean result = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files == null) {
                return path.delete();
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    result &= !FileUtil.deleteDirectory(files[i]);
                }
                result &= files[i].delete();
            }
        }
        return result &= path.delete();
    }

    public static boolean cleanDirectory(File path) {
        boolean result = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files == null) {
                return path.delete();
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    result &= !FileUtil.deleteDirectory(files[i]);
                }
                result &= files[i].delete();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File source, File destination) {
        boolean result = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            int nbLecture;
            destination.createNewFile();
            sourceFile = new FileInputStream(source);
            destinationFile = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            while ((nbLecture = sourceFile.read(buffer)) != -1) {
                destinationFile.write(buffer, 0, nbLecture);
            }
            result = true;
        }
        catch (FileNotFoundException f) {
            System.err.println(f);
            result = false;
        }
        catch (IOException e) {
            System.err.println(e);
            result = false;
        }
        finally {
            try {
                sourceFile.close();
            }
            catch (Exception f) {}
            try {
                destinationFile.close();
            }
            catch (Exception f) {}
        }
        return result;
    }

    public static boolean copyDirectory(File source, File destination) {
        boolean result = true;
        if (!source.exists()) {
            return false;
        }
        if (!destination.mkdirs() && !destination.isDirectory()) {
            return false;
        }
        File[] files = source.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File newDestination = new File(destination.getPath() + File.separator + files[i].getName());
            if (files[i].isDirectory()) {
                result &= FileUtil.copyDirectory(files[i], newDestination);
                continue;
            }
            result &= FileUtil.copy(files[i], newDestination);
        }
        return result;
    }

    public static List<File> list(File dir, FileFilter filter, boolean recurse) {
        LinkedList<File> list = null;
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            return null;
        }
        list = new LinkedList<File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() && recurse) {
                list.addAll(FileUtil.list(files[i], filter, recurse));
                continue;
            }
            if (filter != null && !filter.accept(files[i])) continue;
            list.add(files[i]);
        }
        return list;
    }

    public static List<String> listPathes(File dir, FileFilter filter, boolean recurse) {
        LinkedList<String> list = null;
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            return null;
        }
        list = new LinkedList<String>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() && recurse) {
                list.addAll(FileUtil.listPathes(files[i], filter, recurse));
                continue;
            }
            if (filter != null && !filter.accept(files[i])) continue;
            list.add(PathUtil.URIToPath(files[i].getPath()));
        }
        return list;
    }

    public static List<File> list(File source, final String regex, boolean recurse) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname != null) {
                    String path = pathname.getPath();
                    if (path != null) {
                        return path.matches(regex);
                    }
                    return false;
                }
                return false;
            }
        };
        return FileUtil.list(source, filter, recurse);
    }
}

